;[sysview type="load" storage="./data/others/plugin/tempura_autosave/load.html"]
[iscript]
// setting
var autosaver_setting = {
  var_name              : "tempura_autosave_data",
  slot_num              :  parseInt(mp.slot)||5,
  tag_name_save         : "tempura_autosave",
  tag_name_load         : "tempura_autoload",
  tag_name_del          : "tempura_autodelete",
  message_save          : "オートセーブ<img src='./data/fgimage/loading.png' class='loading'>",
  html_load             : "./data/others/plugin/tempura_autosave/autoload.html"
};
var log                 =  function(message){alertify.log(message,"",1000)};
var index_start         =  0;
var log_default         = mp.log||"false";//◆"false";
var initial_title       =  $.lang("not_saved");
var initial_save_date   = "";
var initial_img_data    = "";
var initial_playtime    = "&nbsp;";
var initial_level       = "";
var initial_life        = "";
var fade_in             = 200;
var fade_out            = 200;
var img_html            = "" + "<img style=\"width:100px\">";
var li_html             = "" +
	"<li class=\"save_display_area save_list_item{{:no_date}} stamp_{{:clearstamp}}\" data-num=\"{{:num}}\">"+
		"<span class=\"save_list_item_thumb\"><small>File No.</small>" + "{{:numver}}" +
		  "<span class=\"save_list_item_stamp\"></span>"+
		"</span>"+ 
		"<span class=\"save_list_item_area\">"+
			"<span class=\"save_list_item_date\">{{:save_date}}</span>"+
			"<span class=\"save_list_item_level\">{{:level}}</span>"+
			"<span class=\"save_list_item_challenge\">{{:challenge}}</span>"+
			"<span class=\"save_list_item_hyper\">{{:hyper}}</span>"+
			"<span class=\"save_list_item_playcount\">{{:playcount}}</span>"+
			"<span class=\"save_list_item_life life_{{:life}}\">&nbsp;</span>"+
			"<span class=\"save_list_item_playtime\">{{:playtime}}</span>"+
			"<span class=\"save_list_item_stamp\"></span>"+
		"</span>"+
	"</li>";
// build
var object_name="tempura";
var saver_name="saver";
var exsaver_name="autosaver";
var Tempura=function(){this.kag=TG};
if(typeof TG.menu[object_name]==="undefined"){TG.menu[object_name]=new Tempura()};


var Saver=function(){
	this.kag=TG;
	this.version="1.1.0";
	
	this.save=function(var_name,slot_num,title,slot,call_back){
		var that=this;
		slot=parseInt(slot);
		if(typeof title!=="string")title="%m";
		title=title.replace("%m",this.kag.stat.current_message_str);
		
		
		this.kag.menu.snapSave(title,function(){
			var sf=that.kag.variable.sf;
			var snap=that.kag.menu.snap;
			
			//セーブデータ追加
			snap.playtime = TG.stat.f.playtime;
			snap.level = TG.stat.f.level;
			snap.life = TG.stat.f.life;
			snap.challenge= TG.stat.f.challenge;
			snap.hyper= TG.stat.f.hyper;
			if(TG.stat.f.clear_flag==true){
				if (TG.stat.f.nomiss==true) var clearstamp = "nomiss_clear";
				else if (TG.stat.f.life>6) var clearstamp = "good_clear"
				else var clearstamp = "clear"
			} else var clearstamp = "";
			snap.clearstamp = clearstamp;
			snap.playcount = TG.stat.f.play_count;
			//ここまで
			
			var arr=sf[var_name];
			if(!isNaN(slot)){
				arr[slot-index_start]=$.extend(true,{},snap)
			}else{
				arr.unshift($.extend(true,{},snap));
				if(arr.length>slot_num){
					arr.pop()
				}
			}
			that.kag.saveSystemVariable();
			if(call_back)call_back()
		})
	};
	
	this.load=function(var_name,slot){
		slot=parseInt(slot)||index_start;
		slot=slot-index_start;
		var snap=this.kag.variable.sf[var_name][slot];
		if(this.isWS(snap)){
			this.kag.ftag.nextOrder()
		}else{
			this.kag.menu.loadGameData($.extend(true,{},snap));
			this.kag.stat.is_skip=false;
			this.kag.ftag.nextOrder()
		}
	};
	
	this.getWS=function(){
		
		var ret={
			title:initial_title,
			current_order_index:-1,
			img_data:initial_img_data,
			save_date:initial_save_date,
			//追加
			playtime:initial_playtime,
			level:initial_level,
			life:initial_life,
			clearstamp:"",
			playcount:"&nbsp;",
			challenge:"",
			hyper:$.lang("not_saved"),
			//
			stat:{},
			layer:{}
		};
		
		return ret
	};
	
	this.isWS=function(snap){
		if(!snap||snap.current_order_index<=0)return true;
		else return false
	};
	
	this.del=function(var_name,slot){
		var arr=this.kag.variable.sf[var_name];
		if(typeof slot==="undefined"||slot==""){
			this.init(var_name,arr.length)
		}else{
			slot=parseInt(slot);
			arr[slot]=this.getWS()
		};
		this.kag.saveSystemVariable()
	};
	
	this.init=function(var_name,slot_num){
		var arr=this.kag.variable.sf[var_name];
		for(var i=0;i<slot_num;i++){
			arr[i]=this.getWS()
		}
	}
};

if(typeof TG.menu[object_name][saver_name]==="undefined"){
	TG.menu[object_name][saver_name]=new Saver()
};

var SaverEx=function(setting){
	var that=this;
	var exsaver=this;
	this.j_savelist=null;
	this.kag=TG;
	this.var_name=setting.var_name;
	this.slot_num=setting.slot_num;
	this[saver_name]=this.kag.menu[object_name][saver_name];
	this.isWS=this[saver_name].isWS;
	
	this.save=function(title,slot,call_back){
		this[saver_name].save(
			this.var_name,
			this.slot_num,
			title,
			slot,
			function(){if(call_back)call_back()}
		)
	};
	
	this.load=function(slot){
		this[saver_name].load(this.var_name,slot)
	};
	this.del=function(slot){
		this[saver_name].del(this.var_name,slot)
	};

	this.updateSavelist=function(){
		var snap_array=exsaver.kag.variable.sf[this.var_name];
		var ul_html="";
		for(var i=0;i<snap_array.length;i++){
			var snap=snap_array[i];
			if(parseInt(snap.playtime)>0){
				var hour = parseInt(snap.playtime / 3600);
				var min = parseInt((snap.playtime / 60) % 60);
				var sec = snap.playtime % 60;
				if(hour < 10) { hour = "0" + hour; }
				if(min < 10) { min = "0" + min; }
				if(sec < 10) { sec = "0" + sec; }
				var playtime= hour + '時間' + min + '分' + sec + '秒';
			}else playtime=snap.playtime;
			if(snap.clearstamp =="nomiss_clear"){
				var challenge=snap.challenge;
			}else if(snap.clearstamp =="good_clear"){
				var challenge=snap.challenge;
			}else{
				var challenge="";
			}
			var hyper=(snap.hyper==undefined)?"":snap.hyper;
			var nodata=(exsaver.isWS(snap))?" nodata":"";
			var numver="0"+(parseInt(i)+1);
			
			var img=img_html;
			var li=li_html;
			li=li.replace("{{:no_date}}",nodata);
			li=li.replace("{{:save_date}}",snap.save_date);
			li=li.replace("{{:title}}",snap.title);
			li=li.replace("{{:img}}",img);
			li=li.replace("{{:playtime}}",playtime);
			li=li.replace("{{:level}}",snap.level);
			li=li.replace("{{:life}}",snap.life);
			li=li.replace("{{:numver}}",numver);
			li=li.replace("{{:playcount}}",snap.playcount);
			li=li.replace("{{:challenge}}",challenge);
			li=li.replace("{{:hyper}}",hyper);
			li=li.replace("{{:clearstamp}}",snap.clearstamp);
			li=li.replace("{{:num}}",i);
			ul_html+=li
		};
	
		this.j_savelist=$(ul_html);
		this.j_savelist.find("img").each(function(i){
			if(snap_array[i].img_data)this.src=snap_array[i].img_data;else this.remove()
		})
	};
	
	this.init=function(){
		if(typeof exsaver.kag.variable.sf[this.var_name]==="undefined"){
			exsaver.kag.variable.sf[this.var_name]=[];
			TG.menu[object_name][saver_name].init(this.var_name,this.slot_num)
		}
	};
	this.init();


	this.displayLoad=function(){
		var exsaver=this;
		var snap_array=exsaver.kag.variable.sf[this.var_name];
		/*--Add--◆いいえ/削除の時のちらつき防止？--*/
		if($('#save_wrap').length)var j_save=$("#save_wrap").html(this.html);
		else/*--End Add--*/ var j_save=$("<div id=\"save_wrap\" style=\"display:none;opacity:0;z-index:100000001;position:absolute;width:100%;height:100%;\">").appendTo("#tyrano_base").html(this.html);
		var ul=j_save.find(".save_list").css("font-family",exsaver.kag.config.userFace);
		this.updateSavelist();
		if(snap_array)ul.append(this.j_savelist);
		/*--Change--◆j_save.css("display","block");--*/
		j_save.fadeIn(fade_in);
		/*--End Change--*/
		j_save.animate({"opacity":"1"},fade_in);
		//exsaver.kag.ftag.startTag("freeimage",{layer:"1"});
		j_save.find(".save_display_area").each(function(){
			$(this).click(function(e){
				var slot=parseInt($(this).attr("data-num"));
				var snap=snap_array[slot];
				/*--Add--◆slotをゲーム変数に格納--*/
				exsaver.kag.ftag.startTag("eval",{exp:"sf.autosave_slot="+slot});
				
				/*--◆alert実行--*/
				exsaver.LoadAlert(slot);
				exsaver.kag.ftag.startTag("playse",{storage:"decision7.ogg",stop:"true"});
				/*--End Add--*/
				
				/*---Del---
				if(exsaver.isWS(snap))return false;
				exsaver.kag.tmp.sleep_game=snap;
				$("#save_wrap").fadeOut(fade_out,function(){
					$(this).remove()
				});
				var layer_menu=TYRANO.kag.layer.getMenuLayer();
				layer_menu.hide();
				layer_menu.empty();
				if(exsaver.kag.stat.visible_menu_button==true)$(".button_menu").show();
				exsaver.kag.ftag.startTag("awakegame",{variable_over:"false",bgm_over:"false"})
				---End Del---*/
			});
			$(this).hover(
				function () {
					TG.ftag.startTag("playse",{storage:"Accent32-1.ogg",stop:"true"});
				},
		  	function () {}
			);
		});
		
		
		/*--Add--◆セーブスロットをクリックしたら選択肢を出す。--*/
		this.LoadAlert=function(slot){
			var exsaver=this;
			var snap_array=exsaver.kag.variable.sf[this.var_name];
			var snap=snap_array[slot];
			
			var nodata=(exsaver.isWS(snap))?" class='nodata'":"";
			var FileNo = parseInt(slot)+1;
			var alert_html="<div class='load_alert_area'><h3>File No."+FileNo+"</h3><p>このセーブファイルではじめますか？</p><ul"+nodata+"><li class='yes'>はい</li><li class='no'>いいえ</li><li class='delete'>削除する</li></ul></div>";
			var layer_menu=TYRANO.kag.layer.getMenuLayer();
			layer_menu.hide();
			layer_menu.empty();
			$("<div class='load_alert' style='display:none;'>").appendTo("#save_wrap").html(alert_html).css("font-family",exsaver.kag.config.userFace);
			$("[data-num='"+slot+"']").addClass('load_data');
			$(".load_alert").fadeIn(fade_in);
			$(".load_alert_area").addClass('load_alert_show');
				
			$(".yes").click(function(){
				if(TG.stat.visible_menu_button==true)$(".button_menu").show();
				/*色々消す*/
				TG.ftag.startTag("clearfix");
				TG.ftag.startTag("chara_hide_all",{time:"0"});
				TG.ftag.startTag("freeimage",{layer:"1",time:"0"});
				$("#root_layer_game").find("div").css("background-image","none");//背景画像削除はどうすれば…
				setTimeout(function(){
					$("#save_wrap").fadeOut(fade_out,function(){
						$("#save_wrap").remove()
					});
					exsaver.kag.ftag.startTag("playse",{storage:"decision7.ogg",stop:"true"});
					if(exsaver.isWS(snap)){
						TG.ftag.startTag("breakgame");
						TG.ftag.startTag("jump",{storage:"title.ks",target:"*newgame"})
					}else{
						//TG.tmp.sleep_game=snap;
						//TG.ftag.startTag("awakegame",{variable_over:"false",bgm_over:"false"})
						TG.stat.f = snap.stat.f;
						TG.ftag.startTag("breakgame");
						TG.ftag.startTag("jump",{storage:"title.ks",target:"*loadgame"})
					}
				},50);
			});

			$(".no").click(function(){
				exsaver.kag.ftag.startTag("playse",{storage:"Motion-Pop41-1.ogg",stop:"true"});
				$("[data-num='"+slot+"']").removeClass('load_data');
				$(".load_alert").fadeOut(fade_out,function(){
					$(".load_alert").remove();
				});
			});
			
			$(".delete").click(function(){
				if(exsaver.isWS(snap)){
				}else{
					exsaver.kag.ftag.startTag("playse",{storage:"Motion-Pop41-1.ogg",stop:"true"});
					$("[data-num='"+slot+"']").removeClass('load_data');
					$(".load_alert").fadeOut(fade_out,function(){
						$(".load_alert").remove();
					});
					if(TG.stat.is_adding_text)return false;
					exsaver.del(String(slot));
					setTimeout(function(){
						exsaver.displayLoad();
					},505);
				}
			});
			
			if($(".load_alert_area").find("ul").hasClass("nodata")){
				$(".load_alert_area").find("li.yes,li.no").hover(
					function () {
						TG.ftag.startTag("playse",{storage:"Accent32-1.ogg",stop:"true"});
					},
		  		function () {}
				);
			}else{
				$(".load_alert_area").find("li").hover(
					function () {
						TG.ftag.startTag("playse",{storage:"Accent32-1.ogg",stop:"true"});
					},
		  		function () {}
				);
			};

		};
		/**End Add**/

		var close=function(flag,delay){
			$("#save_wrap").delay(delay).fadeOut(fade_out,function(){
				$(this).remove()
			});
			exsaver.kag.ftag.startTag("awakegame",{});
			var layer_menu=exsaver.kag.layer.getMenuLayer();
			layer_menu.hide();
			layer_menu.empty();
			if(!flag&&exsaver.kag.stat.visible_menu_button==true)$(".button_menu").show()
		};
		j_save.find(".button_normalsave").click(function(){
			close(true,300);
			exsaver.kag.menu.displayLoad()
		});
		j_save.find(".button_smart").hide();
		if($.userenv()!="pc"){
			j_save.find(".button_smart").show();
			j_save.find(".button_arrow_up").click(function(){
				var now=j_save.find(".area_save_list").scrollTop();
				var pos=now-160;
				j_save.find(".area_save_list").animate({scrollTop:pos},{queue:false})
			});
			j_save.find(".button_arrow_down").click(function(){
				var now=j_save.find(".area_save_list").scrollTop();
				var pos=now+160;
				j_save.find(".area_save_list").animate({scrollTop:pos},{queue:false})
			})
		};
		
		var save_list_height=parseInt($(".tyrano_base").outerHeight())-parseInt($(".save_list").offset().top);
		
		$(".area_save_list").css("height",save_list_height);
		
		j_save.on("contextmenu",function(){close()});
		
		j_save.find(".button_close").hover(
			function(){
				exsaver.kag.ftag.startTag("playse",{storage:"Accent32-1.ogg",stop:"true"})
			},
			function(){}
		);
		j_save.find(".button_close").on("click",function(){
			exsaver.kag.ftag.startTag("playse",{storage:"cancel2.ogg",stop:"true"});
			close()
		});
	};
	
	var tag={};
	tag[setting.tag_name_save]={
		pm:{
			slot:"",
			title:"%m",
			log:log_default
		},
		start:function(pm){
			if(this.kag.stat.is_adding_text)return false;
			var that=this;
			var ftag=this.kag.ftag;
			var next_tag=ftag.array_tag[++ftag.current_order_index].name;
			var opt={
				is_auto:this.kag.stat.is_auto,
				nextOrder:false,
				showEvLayer:false,
				callback:null
			};
			switch(next_tag){
				case"s":ftag.startTag(next_tag);break;
				case"p":this.kag.stat.flag_ref_page=true;
				case"l":opt.showEvLayer=true;
				if(this.kag.stat.is_skip==true){
					opt.nextOrder=true
				}else if(this.kag.stat.is_auto==true){
					opt.callback=function(){
						that.kag.stat.is_wait_auto=true;
						var auto_speed=that.kag.config.autoSpeed;
						if(that.kag.config.autoSpeedWithText!="0"){
							var cnt_text=that.kag.stat.current_message_str.length;
							auto_speed=parseInt(auto_speed)+parseInt(that.kag.config.autoSpeedWithText)*cnt_text
						}
						setTimeout(function(){
							if(that.kag.stat.is_wait_auto==true)
							if(that.kag.tmp.is_vo_play==true)that.kag.tmp.is_vo_play_wait=true;
							else that.kag.ftag.nextOrder()
						},auto_speed)
					}
				}
				break;
				default:ftag.current_order_index--;
				opt.nextOrder=true
			};
			exsaver.save(pm.title,pm.slot,function(){
				if(pm.log=="true")log(setting.message_save);
				if(opt.nextOrder)that.kag.ftag.nextOrder();
				if(opt.showEvLayer)that.kag.layer.layer_event.show();
				if(opt.callback)opt.callback()
			})
		}
	};

	tag[setting.tag_name_load]={
		pm:{},
		start:function(pm){
			var that=this;
			if(that.kag.stat.is_adding_text)return false;
			exsaver.load(pm.slot)
		}
	};

	tag[setting.tag_name_del]={
		pm:{},
		start:function(pm){
			var that=this;
			if(that.kag.stat.is_adding_text)return false;
			exsaver.del(pm.slot);
			that.kag.ftag.nextOrder()
		}
	};
	
	for(var tag_name in tag){
		TG.ftag.master_tag[tag_name]=object(tag[tag_name]);
		TG.ftag.master_tag[tag_name].kag=TG
	};
		
	if(setting.html_load)$.get(setting.html_load,function(text){
		exsaver.html=text
	})
};
	
if(typeof TG.menu[object_name][exsaver_name]==="undefined"){
	TG.menu[object_name][exsaver_name]=new SaverEx(autosaver_setting)
};

$('head link:last').after('<link rel="stylesheet" href="./data/others/plugin/tempura_autosave/style.css">');

[endscript]
[return]