# ティラノスクリプト用「CSV読込プラグイン」

## 概要

- CSVファイルを任意のティラノ変数へ格納するプラグインです。
- データを、配列または連想配列へ変更します。
- 任意の f、sf、tf 変数を指定できます。

## 使い方

1. 「mc_loadcsv」フォルダを、「data/other/plugin/」へ入れてください。
2. CSVファイルは、「data/other/plugin/mc_loadcsv/」へ保存してください。
3. first.ks 等に下記コードを記述しプラグインを読み込みます。※パラメータはありません。
   ```
   [plugin name="mc_loadcsv"]
   ```
4. `[mc_loadcsv]`タグでCSVファイルを読み込みます。
   ```
   [mc_loadcsv file=sample.csv var="f.test" format=ObjectO split="_EOF" br="<br>"]
   ```

## 追加タグ

**[mc_loadcsv]**

CSVファイルを読み込む為のタグです。  
※ [plugin]タグのみではCSVは読み込みません。

### パラメーター

| パラメータ名 | 必須 | 説明 | 初期値 |
| ------------| :--: | ------- | :----: |
| file        |  〇  | CSVファイル名（拡張子必要）<br>※CSVファイルは「mc_loadcsv」フォルダ内に保存してください。<br>※http://～ とURLでも指定できます。 |  |
| var         |  〇  | 保存先変数名（f.hoge など） f、sf、tf 対応。<br>変数の階層は3段までです。（例：sf.hoge.fuga.foo） |  |
| format      |  ×   | 配列パターンを指定します（Array/ArrayA/ArrayO/Object/ObjectA/ObjectO）<br> ※formatは自分で作る事も可能です（後述）  | ArrayA |
| split       |  ×   | 分割用文字列を指定します（文字列： \_eof など）<br> ※指定が無ければ改行で分割します | \n |
| br          |  ×   | 改行コードを指定の文字列に置換します。（文字列：\<br\> など）<br> ※split指定必須  |  |
| join        |  ×   | CSVを同じ変数に追加する場合は true。<br>※連想配列は同じ key の値は上書きになります。 | false |
| wait        |  ×   | 読み込みの完了を待つ場合は true。 | false |

## formatパラメータについて

<details open="false">
<summary>折り畳み</summary>

### Array

**配列**  
行に関係なくだらだらと単純に配列にします。

**CSVデータ例**
| | A | B | C | ... |
| :------: | :-: | :-: | :-: | :-: |
| <b>1</b> | A1 | B1 | C1 | ... |
| <b>2</b> | A2 | B2 | C2 | ... |
| <b>3</b> | A3 | B3 | C3 | ... |

```
sf.hoge = [A1,B1,C1...,A2,B2,C2,...,A3,B3,C3,...]
```

### ArrayA

**配列-配列（多次元配列）**  
行ごとに配列になります。（デフォルト）

**CSVデータ例**
| | A | B | C | ... |
| :------: | :-: | :-: | :-: | :-: |
| <b>1</b> | A1 | B1 | C1 | ... |
| <b>2</b> | A2 | B2 | C2 | ... |
| <b>3</b> | A3 | B3 | C3 | ... |

```
sf.hoge = [
	[A1,B1,C1],
	[A2,B2,C3],
	...
]
```

### ArrayO

**配列-連想配列**  
行ごとに、連想配列を入れて行きます。  
1行目が key になります（TIPプラグインと同じ）

**CSVデータ例**
| | A | B | C | ... |
| :------: | :-: | :-: | :-: | :-: |
| <b>1</b> | A1 | B1 | C1 | ... |
| <b>2</b> | A2 | B2 | C2 | ... |
| <b>3</b> | A3 | B3 | C3 | ... |

```
sf.hoge = [
	{A1:A2,B1:B2,C1:C2},
	{A1:A3,B1:B3,C1:C3},
	...
]
```

### Object

**連想配列**  
1 行目に key と value が必須になります。  
その他の項目は、あっても無視されます。  
※A1=key、B1=value の場合

**CSVデータ例**
| | A | B | C | ... |
| :------: | :-: | :---: | :-: | :-: |
| <b>1</b> | key | value | C1 | ... |
| <b>2</b> | A2 | B2 | C2 | ... |
| <b>3</b> | A3 | B3 | C3 | ... |

```
sf.hoge = {
	A2:B2,
	A3:B3,
	...
}
```

### ObjectA

**連想配列-配列**  
1行目に key 必須です。 ※A1=key の場合

**CSVデータ例**
| | A | B | C | D | ... |
| :------: | :-: | :---: | :-: | :-: | :-: |
| <b>1</b> | key | B1 | C1 | D1 | ... |
| <b>2</b> | A2 | B2 | C2 | D2 | ... |
| <b>3</b> | A3 | B3 | C3 | D3 | ... |

```
sf.hoge = {
	A2:[B2,C2,D2....],
	A3:[B3,C3,D3,...],
	...
}
```

これ、どやって使うのかわからんです・・・

### ObjectO

**連想配列-連想配列**  
1行目に key 必須です。※A1=key の場合

**CSVデータ例**
| | A | B | C | D | ... |
| :------: | :-: | :---: | :-: | :-: | :-: |
| <b>1</b> | key | B1 | C1 | D1 | ... |
| <b>2</b> | A2 | B2 | C2 | D2 | ... |
| <b>3</b> | A3 | B3 | C3 | D3 | ... |

```
sf.hoge = {
	A2:{B1:B2,C1:C2,D1:D2,...},
	A3:{B1:B3,C1:C3,D1:D3,...},
	...
}
```

</details>

## CSVファイルについて

- 文字コードは**UTF-8**にしてください。
- CSVの値は、全て「文字列」になります。
- ゲームに組み込む時は「mc_loadcsv」フォルダ内に保存してください。  
  フォルダ管理する場合は「file=フォルダ名/ファイル名」のように記述してください。

## 改行コードについて

### セル内で改行コードを使いたい場合

1. CSVファイルの最後のセルに分割用のキー（本文に含まない文字）を記入します。  
   例：_EOF
2. `[mc_loadcsv]` タグに `split` パラメータで分割用のキーを指定します。  
   ```
   [mc_loadcsv split="_EOF" （他パラメータ略）]
   ```

※`format=Object` 以外の場合、分割用キーの後にあるデータは次の最初のデータとして扱われますのでご注意ください。

### 改行コードを一部置換、一部残したい場合

1. 残したい改行の前に改行コード `\n` を記述してください。
2. `[mc_loadcsv]` タグに `br` パラメータで置換文字を指定します。

## formatを自作する方法

<details>
<summary>折り畳み</summary>

1. 関数名を `mc_loadcsv.hoge` と連想配列関数にしてデータを処理します。（`hoge` 部分は任意）  
   引数1はCSVデータ、引数2はjoin時の元データが入ります。
2. 変換後のデータは `return` で返します。
3. 適当な名前のjsファイルにして「data/others」に保存します。
4. `[plugin name=mc_loadcsv]` の後に `[loadjs]`タグで呼び出します。
5. `[mc_loadcsv]` タグの `format` パラメータに `hoge` を指定します。  
   ※大文字小文字は正確に指定してください。

```js
mc_loadcsv.hoge = function(data,oridata){
	let newArray;
	（何らかの処理）
	return newArray;
};
```

```
[plugin name=mc_loadcsv]
[loadjs file=hoge.js]
[mc_loadcsv 略 format=hoge]
```

</details>

## 動作確認

ティラノスクリプト v521f

## 免責

このプラグインを使用したことにより生じた損害・損失に対して制作者は一切責任を負いません。

## ライセンス

- このプラグインは MITライセンス です。  
  ライセンス表示はjsファイル上部に記述しています。
- 利用報告・クレジット表記は任意です。

## 寄付のお願い

お役に立てましたら寄付を頂けるととても嬉しいです。  
開発費やサイト運営費などに充てさせて頂きます。  
詳細はWEBサイトを参照してください。  
https://memocho.no-tenki.me/terms#donation

## 制作者

name ： hororo  
site ： めも調 [https://memocho.no-tenki.me/](https://memocho.no-tenki.me/)  
mail ： ruru.amu@gmail.com  
twitter ： @hororo_memocho

## 更新履歴

| 更新日   | Ver   | 詳細                               |
| -------- | ----- | ---------------------------------- |
| 2023/5/1 | v1.01 | コード修正。MITライセンスへ変更。 |
| 2022/5/8 | v1.00 | 配布開始。                         |
